/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.ICreatureTFC;
import net.dries007.tfc.api.types.IHuntable;
import net.dries007.tfc.api.types.IPredator;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.objects.blocks.agriculture.BlockCropDead;
import net.dries007.tfc.objects.blocks.agriculture.BlockCropTFC;
import net.dries007.tfc.objects.blocks.plants.BlockMushroomTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.items.ItemSeedsTFC;
import net.dries007.tfc.objects.te.TECropBase;
import net.dries007.tfc.objects.te.TEPlacedItemFlat;
import net.dries007.tfc.types.DefaultPlants;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.RegenRocksSticks;
import net.dries007.tfc.util.RegenWildCrops;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.dries007.tfc.world.classic.worldgen.WorldGenBerryBushes;
import net.dries007.tfc.world.classic.worldgen.WorldGenPlantTFC;
import net.dries007.tfc.world.classic.worldgen.WorldGenTrees;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Mod.EventBusSubscriber(modid="tfc")
public class WorldRegenHandler {
    private static final RegenRocksSticks ROCKS_GEN = new RegenRocksSticks(true);
    private static final RegenWildCrops CROPS_GEN = new RegenWildCrops();
    private static final WorldGenBerryBushes BUSH_GEN = new WorldGenBerryBushes();
    public static final WorldGenPlantTFC PLANT_GEN = new WorldGenPlantTFC();
    private static final Random RANDOM = new Random();
    private static final List<ChunkPos> POSITIONS = new LinkedList<ChunkPos>();

    @SubscribeEvent
    public static void onChunkLoad(ChunkDataEvent.Load event) {
        ChunkDataTFC chunkDataTFC = ChunkDataTFC.get(event.getChunk());
        if (event.getWorld().field_73011_w.getDimension() == 0 && chunkDataTFC.isInitialized() && POSITIONS.size() < 1000 && CalendarTFC.CALENDAR_TIME.getMonthOfYear().isWithin(Month.APRIL, Month.JULY) && !chunkDataTFC.isSpawnProtected() && CalendarTFC.CALENDAR_TIME.getTotalYears() > chunkDataTFC.getLastUpdateYear()) {
            POSITIONS.add(event.getChunk().func_76632_l());
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.END && !POSITIONS.isEmpty()) {
            double tps = Helpers.getTPS(event.world, 0);
            ChunkPos pos = POSITIONS.remove(0);
            if (tps > (double)ConfigTFC.General.WORLD_REGEN.minRegenTps) {
                Chunk chunk = event.world.func_72964_e(pos.field_77276_a, pos.field_77275_b);
                BlockPos blockPos = pos.func_180331_a(0, 0, 0);
                ChunkDataTFC chunkDataTFC = ChunkDataTFC.get(event.world, pos.func_180331_a(0, 0, 0));
                IChunkProvider chunkProvider = event.world.func_72863_F();
                IChunkGenerator chunkGenerator = ((ChunkProviderServer)chunkProvider).field_186029_c;
                if (CalendarTFC.CALENDAR_TIME.getMonthOfYear().isWithin(Month.APRIL, Month.JULY) && !chunkDataTFC.isSpawnProtected() && CalendarTFC.CALENDAR_TIME.getTotalYears() > chunkDataTFC.getLastUpdateYear()) {
                    if (ConfigTFC.General.WORLD_REGEN.sticksRocksModifier > 0.0) {
                        WorldRegenHandler.removeAllPlacedItems(event.world, pos);
                        double rockModifier = ConfigTFC.General.WORLD_REGEN.sticksRocksModifier;
                        ROCKS_GEN.generate(RANDOM, pos.field_77276_a, pos.field_77275_b, event.world, chunkGenerator, chunkProvider);
                        float density = chunkDataTFC.getFloraDensity();
                        List<Tree> trees = chunkDataTFC.getValidTrees();
                        int stickDensity = 3 + (int)((double)(4.0f * density) + (double)(1.5f * (float)trees.size()) * rockModifier);
                        if (trees.isEmpty()) {
                            stickDensity = 1 + (int)((double)(1.5f * density) * rockModifier);
                        }
                        WorldGenTrees.generateLooseSticks(RANDOM, pos.field_77276_a, pos.field_77275_b, event.world, stickDensity);
                    }
                    WorldRegenHandler.removeCropsAndMushrooms(event.world, pos);
                    WorldRegenHandler.removeSeedBags(event.world, pos);
                    float floraDensity = chunkDataTFC.getFloraDensity();
                    float floraDiversity = chunkDataTFC.getFloraDiversity();
                    Plant mushroom = (Plant)TFCRegistries.PLANTS.getValue(DefaultPlants.PORCINI);
                    if (mushroom != null) {
                        PLANT_GEN.setGeneratedPlant(mushroom);
                    }
                    for (float i = (float)RANDOM.nextInt(Math.round(3.0f / floraDiversity)); i < (1.0f + floraDensity) * 5.0f; i += 1.0f) {
                        BlockPos blockMushroomPos = event.world.func_175645_m(blockPos.func_177982_a(RANDOM.nextInt(16) + 8, 0, RANDOM.nextInt(16) + 8));
                        PLANT_GEN.func_180709_b(event.world, RANDOM, blockMushroomPos);
                    }
                    CROPS_GEN.generate(RANDOM, pos.field_77276_a, pos.field_77275_b, event.world, chunkGenerator, chunkProvider);
                    int worldX = pos.field_77276_a << 4;
                    int worldZ = pos.field_77275_b << 4;
                    BlockPos blockpos = new BlockPos(worldX, 0, worldZ);
                    Biome biome = event.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
                    WorldRegenHandler.removePredators(event.world, pos);
                    WorldRegenHandler.regenPredators(event.world, biome, worldX + 8, worldZ + 8, 16, 16, RANDOM);
                    chunkDataTFC.resetLastUpdateYear();
                }
                chunk.func_76630_e();
                ((ChunkProviderServer)chunkProvider).func_189549_a(chunk);
            }
        }
    }

    private static void removePredators(World world, ChunkPos pos) {
        for (ClassInheritanceMultiMap target : world.func_72964_e(pos.field_77276_a, pos.field_77275_b).func_177429_s()) {
            target.forEach(entity -> {
                if (entity instanceof IPredator || entity instanceof IHuntable && !entity.func_145818_k_()) {
                    entity.func_184174_b(false);
                    entity.func_70106_y();
                }
            });
        }
    }

    private static void removeCropsAndMushrooms(World world, ChunkPos pos) {
        for (int xX = 0; xX < 16; ++xX) {
            for (int zZ = 0; zZ < 16; ++zZ) {
                BlockRockVariant soilRock;
                IBlockState soil;
                BlockPos topPos = world.func_175672_r(pos.func_180331_a(xX, 0, zZ));
                IBlockState topState = world.func_180495_p(topPos);
                Block topBlock = topState.func_177230_c();
                if (topState.func_185904_a().func_76224_d() || !(topBlock instanceof BlockCropDead) && !(topBlock instanceof BlockMushroomTFC) || !((soil = world.func_180495_p(topPos.func_177977_b())).func_177230_c() instanceof BlockRockVariant) || (soilRock = (BlockRockVariant)soil.func_177230_c()).getType() == Rock.Type.FARMLAND) continue;
                world.func_175713_t(topPos);
                world.func_175698_g(topPos);
            }
        }
        Map teTargets = world.func_72964_e(pos.field_77276_a, pos.field_77275_b).func_177434_r();
        ArrayList removals = new ArrayList();
        teTargets.forEach((tePos, te) -> {
            IBlockState state = world.func_180495_p(tePos);
            if (te instanceof TECropBase && state.func_177228_b().containsKey((Object)BlockCropTFC.WILD) && ((Boolean)state.func_177229_b((IProperty)BlockCropTFC.WILD)).booleanValue()) {
                removals.add(tePos);
            }
        });
        for (BlockPos tePos2 : removals) {
            world.func_175713_t(tePos2);
            world.func_175698_g(tePos2);
        }
    }

    private static void removeSeedBags(World world, ChunkPos pos) {
        ArrayList removals = new ArrayList();
        for (ClassInheritanceMultiMap target : world.func_72964_e(pos.field_77276_a, pos.field_77275_b).func_177429_s()) {
            target.forEach(entity -> {
                if (entity instanceof EntityItem && ((EntityItem)entity).func_92059_d().func_77973_b() instanceof ItemSeedsTFC) {
                    removals.add(entity);
                }
            });
        }
        for (Entity e : removals) {
            world.func_72900_e(e);
        }
    }

    private static void removeAllPlacedItems(World world, ChunkPos pos) {
        ArrayList removals = new ArrayList();
        world.func_72964_e(pos.field_77276_a, pos.field_77275_b).func_177434_r().forEach((tePos, te) -> {
            if (te instanceof TEPlacedItemFlat) {
                removals.add(tePos);
            }
        });
        for (BlockPos tePos2 : removals) {
            world.func_175713_t(tePos2);
            world.func_175698_g(tePos2);
        }
    }

    public static void regenPredators(World worldIn, Biome biomeIn, int centerX, int centerZ, int diameterX, int diameterZ, Random randomIn) {
        BlockPos chunkBlockPos = new BlockPos(centerX, 0, centerZ);
        float temperature = ClimateTFC.getAvgTemp(worldIn, chunkBlockPos);
        float rainfall = ChunkDataTFC.getRainfall(worldIn, chunkBlockPos);
        float floraDensity = ChunkDataTFC.getFloraDensity(worldIn, chunkBlockPos);
        float floraDiversity = ChunkDataTFC.getFloraDiversity(worldIn, chunkBlockPos);
        ForgeRegistries.ENTITIES.getValuesCollection().stream().filter(x -> {
            Entity ent;
            if (ICreatureTFC.class.isAssignableFrom(x.getEntityClass()) && ((ent = x.newInstance(worldIn)) instanceof IPredator || ent instanceof IHuntable)) {
                int weight = ((ICreatureTFC)ent).getSpawnWeight(biomeIn, temperature, rainfall, floraDensity, floraDiversity);
                return weight > 0 && randomIn.nextInt(weight) == 0;
            }
            return false;
        }).findAny().ifPresent(entityEntry -> WorldRegenHandler.doGroupSpawning(entityEntry, worldIn, centerX, centerZ, diameterX, diameterZ, randomIn));
    }

    private static void doGroupSpawning(EntityEntry entityEntry, World worldIn, int centerX, int centerZ, int diameterX, int diameterZ, Random rand) {
        ArrayList group = Lists.newArrayList();
        EntityLiving creature = (EntityLiving)entityEntry.newInstance(worldIn);
        if (creature instanceof ICreatureTFC) {
            ICreatureTFC creatureTFC = (ICreatureTFC)creature;
            int fallback = 5;
            int individuals = Math.max(1, creatureTFC.getMinGroupSize()) + rand.nextInt(creatureTFC.getMaxGroupSize() - Math.max(0, creatureTFC.getMinGroupSize() - 1));
            while (individuals > 0) {
                int i = centerX + rand.nextInt(diameterX);
                int k = centerZ + rand.nextInt(diameterZ);
                BlockPos blockpos = worldIn.func_175672_r(new BlockPos(i, 0, k));
                creature.func_70012_b((double)((float)i + 0.5f), (double)blockpos.func_177956_o(), (double)((float)k + 0.5f), rand.nextFloat() * 360.0f, 0.0f);
                if (creature.func_70601_bi()) {
                    if (ForgeEventFactory.canEntitySpawn((EntityLiving)creature, (World)worldIn, (float)((float)i + 0.5f), (float)blockpos.func_177956_o(), (float)((float)k + 0.5f), null) == Event.Result.DENY) {
                        if (--fallback <= 0) break;
                        continue;
                    }
                    fallback = 5;
                    worldIn.func_72838_d((Entity)creature);
                    group.add(creature);
                    creature.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)creature)), null);
                    if (--individuals <= 0) continue;
                    creature = (EntityLiving)entityEntry.newInstance(worldIn);
                    creatureTFC = (ICreatureTFC)creature;
                    continue;
                }
                if (--fallback > 0) continue;
                break;
            }
            creatureTFC.getGroupingRules().accept(group, rand);
        }
    }
}

